package music;
import java.util.GregorianCalendar;
import java.text.SimpleDateFormat;

import art.WorkOfArt;

public class Song implements WorkOfArt {
    
    public static String definition;
    private String title;
    private String author;
    private int year;
    private GregorianCalendar releaseDate;
    
    static {
        definition = "A song is a great thing.";
    }
    
    public Song(String title, String author, int year, GregorianCalendar releaseDate) {
        this.title = title;
        this.author = author;
        this.year = year;
        this.releaseDate = releaseDate;
    }
    
    public Song(String title, String author, GregorianCalendar releaseDate) {
        this.title = title;
        this.author = author;
        this.releaseDate = releaseDate;
        this.year = this.releaseDate.YEAR;
    }
    
    public Song(String title, String author, int year) {
        this.title = title;
        this.author = author;
        this.year = year;
    }
    
    public Song(String title) {
        this.title = title;
//         this.author = author;
//         this.year = year;
    }
    
    public Song() {
    }
    
    public static void define() {
        System.out.println("Songs are typically created by artists.");
    }
    
    public void display() {
        System.out.println('\"' + title + '\"' + ':' + '\n' +
                           '\t' + "author: " + author + '\n' +
                           '\t' + "year: " + year);
    }
    
    public String toString() {
//         return title + ", " + author + ", " + year;
//         return title + ", " + author + " " + (new SimpleDateFormat("MMM dd, yyyy").format(this.releaseDate));
        return title + ", " + author + " (" + (new SimpleDateFormat("MMM dd, yyyy")).format(this.releaseDate.getTime()) + ")";
    }
    
	@Override
	public void describe() {
		display();
//		System.out.println((new SimpleDateFormat("MMM dd, yyyy")).format(this.releaseDate.getTime()));
	}

	@Override
	public void showDate() {
		System.out.println((new SimpleDateFormat("MMM dd, yyyy")).format(this.releaseDate.getTime()));
	}
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    @Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((author == null) ? 0 : author.hashCode());
		result = prime * result + ((releaseDate == null) ? 0 : releaseDate.hashCode());
		result = prime * result + ((title == null) ? 0 : title.hashCode());
		result = prime * result + year;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Song other = (Song) obj;
		if (author == null) {
			if (other.author != null)
				return false;
		} else if (!author.equals(other.author))
			return false;
		if (releaseDate == null) {
			if (other.releaseDate != null)
				return false;
		} else if (!releaseDate.equals(other.releaseDate))
			return false;
		if (title == null) {
			if (other.title != null)
				return false;
		} else if (!title.equals(other.title))
			return false;
		if (year != other.year)
			return false;
		return true;
	}

	public String getTitle() {
        return this.title;
    }
    
    public void setAuthor(String author) {
        this.author = author;
    }
    
    public String getAuthor() {
        return this.author;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    public void setReleaseDate(GregorianCalendar releaseDate) {
        this.releaseDate = releaseDate;
    }
    
    public GregorianCalendar getReleaseDate() {
        return this.releaseDate;
    }

}
